@echo off
setlocal EnableDelayedExpansion

echo =====================================
echo FFMPEG -> WAV (5.1 mit leerem Center/LFE)
echo =====================================

set OUTDIR=wav40_out
if not exist "%OUTDIR%" mkdir "%OUTDIR%"

for %%F in (*.aac *.ac3 *.wav *.aif *.aiff) do (

    echo.
    echo Datei: %%F

    rem -------------------------------
    rem Kanalanzahl ermitteln
    rem -------------------------------
    set CH=
    for /f "delims=" %%C in ('
        ffprobe -v error -select_streams a:0 ^
        -show_entries stream^=channels ^
        -of default^=noprint_wrappers^=1:nokey^=1 "%%F"
    ') do set CH=%%C

    echo Kanaele: !CH!

    rem ===============================
    rem STEREO -> unveraendert
    rem ===============================
    if "!CH!"=="2" (
        echo -> Stereo
        ffmpeg -y -i "%%F" ^
        -c:a pcm_s16le ^
        "%OUTDIR%\%%~nF.wav"
    )

    rem ===============================
    rem 5.1 -> Center & LFE leer
    rem ===============================
    if "!CH!"=="6" (
        echo -> 5.1 (Center & LFE leer)

        ffmpeg -y -i "%%F" ^
        -filter_complex "pan=6c|c0=c0+0.707*c2+c3|c1=c1+0.707*c2+c3|c2=0*c2|c3=0*c3|c4=c4|c5=c5,alimiter=limit=0.99" ^
        -c:a pcm_s16le ^
        "%OUTDIR%\%%~nF.wav"
    )
)

echo.
echo Fertig.
pause
